uniform sampler2D s_tex0;
uniform float radius;
uniform vec2 position; //beacon position in screen coords
uniform float time;
uniform float burning;

void main()
{
	float factor = 1.-length(gl_FragCoord.xy - position);
	float sz = burning * 512.;
	float x = (factor/sz*(-cos(factor*time/5.)/2.+0.5))/sz;
	float y = (factor/sz*( sin(factor*time/5.)/2.+0.5))/sz;

	vec4 color = gl_Color * texture2D(s_tex0, gl_TexCoord[0].xy+vec2(x,y));
	gl_FragColor = color;
}